from typing import List, Optional

from axelrod.action import Action

from axelrod.player import Player

Vector = List[float]

C, D = Action.C, Action.D

class Prober2(Player):
    """
    Plays D, C, C initially. Cooperates forever if opponent played D then C
    in moves 2 and 3. Otherwise plays TFT.

    Names:

    - Prober 2: [Prison1998]_
    """

    name = "Prober 2"
    classifier = {
        "stochastic": False,
        "memory_depth": float("inf"),  # Long memory
        "long_run_time": False,
        "inspects_source": False,
        "manipulates_source": False,
        "manipulates_state": False,
    }

    def strategy(self, opponent: Player) -> Action:
        """Actual strategy definition that determines player's action."""
        turn = len(self.history)
        if turn == 0:
            return D
        if turn == 1:
            return C
        if turn == 2:
            return C
        if turn > 2:
            if opponent.history[1:3] == [D, C]:
                return C
            else:
                # TFT
                return D if opponent.history[-1:] == [D] else C